<xsl:transform version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:fn="http://www.w3.org/2005/xpath-functions"
		xmlns:mx="http://www.mobotix.com/xslfuncs">

<xsl:output method="xml" encoding="utf-8"/>
<!-- note: output method="xml" is chosen because the output will go through another xsl transformation -->
<!-- actually, the output is XHTML conformant -->

<xsl:variable name="translation-context">EMailWatch</xsl:variable>
<xsl:include href="include.xsl"/>

<xsl:template match="/print">

<html>
<head>
  <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
  <style>
	BODY, TD, TH {
	  	font-family: "VAGRounded LT Thin","sans-serif";
  		font-size: 11pt;
  		color: #002080;
	}
  	TD,TH {
  		text-align:left;
  	}
  	TH {
  		background-color: #eeeeee;
  		text-align: center;
  	}
  	hr {
  		color: #002080;
  		height: 2px;
  	}
  	.title {
		font-weight:bold;
		font-size:18pt;
		background-color: #dddddd;
		vertical-align:middle;
	}
  </style>
<title>
	<xsl:call-template name="tr"><xsl:with-param name="source">[MxControlCenter] Dead Man's Switch on</xsl:with-param></xsl:call-template>
	<xsl:text> </xsl:text>
	<xsl:value-of select="data/host"/>
</title>
</head>

<body>
<center>

<table cellspacing="0" border="0" >
<tr>
	<td  align="center">
		<xsl:call-template name="tr"><xsl:with-param name="source">MxControlCenter Notification</xsl:with-param></xsl:call-template>
	</td>
	<td  align="right" bgcolor="#dddddd">
		<img  height="146" border="0" src="cid:image1"/>
	</td>
</tr>
</table>

</center>


<h4>
	<xsl:call-template name="tr"><xsl:with-param name="source">MxControlCenter dead man's switch has been activated.</xsl:with-param></xsl:call-template>
</h4>
<table>
		<tr>	<td><xsl:call-template name="tr"><xsl:with-param name="source">Host:</xsl:with-param></xsl:call-template> </td>
				<td><xsl:value-of select="data/host"/></td></tr>
		<tr>	<td><xsl:call-template name="tr"><xsl:with-param name="source">Time:</xsl:with-param></xsl:call-template> </td>
				<td><xsl:value-of select="data/time"/></td></tr>
</table>


<p>
	<xsl:call-template name="tr"><xsl:with-param name="source">This is an automatically generated e-mail message. Do not reply directly.</xsl:with-param></xsl:call-template>
</p>

<p>
	<xsl:call-template name="tr"><xsl:with-param name="source">Requests should be directed to:</xsl:with-param></xsl:call-template>
</p>
<table>
		<tr><td></td><td><xsl:value-of select="data/contact/name"/></td></tr>
		<xsl:if test="string-length(data/contact/phone) &gt; 0">
		<tr>	<td><xsl:call-template name="tr"><xsl:with-param name="source">Phone:</xsl:with-param></xsl:call-template></td>
				<td><xsl:value-of select="data/contact/phone"/></td></tr>
		</xsl:if>
		<xsl:if test="string-length(data/contact/mail) &gt; 0">
		<tr>	<td><xsl:call-template name="tr"><xsl:with-param name="source">E-Mail:</xsl:with-param></xsl:call-template></td>
				<td>
					<a>
						<xsl:attribute name="href">mailto:<xsl:value-of select="data/contact/mail"/></xsl:attribute>
						<xsl:value-of select="data/contact/mail"/>
					</a></td></tr>
		</xsl:if>
</table>

</body>
</html>

</xsl:template>


</xsl:transform>
